
//Generate Maximum Length Pseudo Noise Sequence
//Windows 7
//Scilab 6.0.0

//Note: Please run the xor.sci dependency file before executing this program
//Assign Initial value for PN generator
x0= 1;
x1= 0;
x2 =0;
x3 =0;
x4= 0;
x5= 0;
x6= 0;
x7= 0;
x8= 0;
N = input('Enter the period of the signal')
for i =1:N
  x1 = x0;
  x8 =x7
  x7 =x6
  x0 =xor(x7,x1)
  x6 =x5
  x5 =x4
  x0 =xor(x1,x5)
  x4 =x3
  x3 =x2;
  x2 =x1;
  x0 =xor(x1,x3);
  disp(i,'The PN sequence at step')
  x = [x1 x2 x3 x4 x5 x6 x7 x8];
  disp(x,'x=')
end
m = [7,8,9,10,11,12,13,17,19];
Nl = 2^m-1;
disp('Table Range of PN Sequence lengths')
disp('Length of shift register (m)')
disp(m)
disp('PN sequence Length (N)')
disp(Nl)

//Execution
//Enter the period of the signal
//5
//
//
// The PN sequence at step
//
//   1.
//
// x=
//
//   1.   1.   0.   0.   0.   0.   0.   0.
//
// The PN sequence at step
//
//   2.
//
// x=
//
//   1.   1.   1.   0.   0.   0.   0.   0.
//
// The PN sequence at step
//
//   3.
//
// x=
//
//   0.   0.   1.   1.   0.   0.   0.   0.
//
// The PN sequence at step
//
//   4.
//
// x=
//
//   1.   1.   0.   1.   1.   0.   0.   0.
// The PN sequence at step
//
//   5.
//
// x=
//
//   1.   1.   1.   0.   1.   1.   0.   0.
//
// Table Range of PN Sequence lengths
//
// Length of shift register (m)
//
//   7.   8.   9.   10.   11.   12.   13.   17.   19.
//
// PN sequence Length (N)
//
//
//         column 1 to 7
//
//   127.   255.   511.   1023.   2047.   4095.   8191.
//
//         column 8 to 9
//
//   131071.   524287.
